# Generated by Django 2.1.4 on 2019-04-04 03:24

from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ('trosnoth', '0025_trosnotharena_profileslowcalls'),
    ]

    operations = [
        migrations.AlterModelOptions(
            name='trosnotharena',
            options={'permissions': (('manage_arena', 'Can edit and manage arenas'),)},
        ),
        migrations.AlterModelOptions(
            name='trosnothserversettings',
            options={'permissions': (('shutdown_server', 'Can shut down server process'),), 'verbose_name_plural': 'Trosnoth server settings'},
        ),
        migrations.AddField(
            model_name='trosnothserversettings',
            name='elephantName',
            field=models.TextField(default='Jerakeen', help_text='What to call the elephant. Elephant owners must be configured directly in the database on the desired TrosnothUser.', verbose_name='Elephant name'),
        ),
        migrations.AddField(
            model_name='trosnothserversettings',
            name='trustClientUsernames',
            field=models.BooleanField(default=False, help_text='Removes the need for players to create accounts on this server by believing the client when it reports the username used to log into the device. This is a security vulnerability as a coder could easily configure their client to pretend that they are someone else. Only use this setting if such an eventuality is low risk and low cost. This setting only works if the privacy/sendusername setting is enabled in policy.ini on client machines.', verbose_name='Trust client usernames'),
        ),
        migrations.AlterField(
            model_name='trosnotharena',
            name='profileSlowCalls',
            field=models.BooleanField(default=False, help_text='Note that this will decrease performance slightly.', verbose_name='Log profiling stats for slow calls'),
        ),
        migrations.AlterField(
            model_name='trosnothserversettings',
            name='welcomeText',
            field=models.TextField(default='Congratulations! You have successfully installed your Trosnoth server. <a href="settings">Click here</a> to configure it.', verbose_name='Welcome html'),
        ),
    ]
